local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

use "`PPP'\use.dta"

local t1="i.cvd_4g i.is_female c.age i.region_code"

postfile tb1cvd4g str30 x CT CTse MI MIse IS ISse ICH ICHse using "`PPP'\results\tb1cvd4g.dta", replace
set more off

tab cvd_4g

post tb1cvd4g ("N") (.) (.) (.) (.) (.) (.) (.) (.)

anova age i.cvd_4g i.is_female i.region_code
margins cvd_4g
mat A=r(table)
post tb1cvd4g ("age") (A[1,1]) (A[2,1]) (A[1,2]) (A[2,2]) (A[1,3]) (A[2,3]) (A[1,4]) (A[2,4])

local covs="bmi_calc sbp_mean dbp_mean random_glucose_x10 met diet_week_eggs diet_week_meat diet_week_fresh_fruit"
foreach cov of local covs {
anova `cov' `t1'
margins cvd_4g
mat A=r(table)
post tb1cvd4g ("`cov'") (A[1,1]) (A[2,1]) (A[1,2]) (A[2,2]) (A[1,3]) (A[2,3]) (A[1,4]) (A[2,4])
}

logistic is_female i.cvd_4g c.age i.region_code
margins cvd_4g
mat A=r(table)
post tb1cvd4g ("is_female") (A[1,1]*100) (.) (A[1,2]*100) (.) (A[1,3]*100) (.) (A[1,4]*100) (.)

logistic region_is_urban i.cvd_4g c.age i.is_female
margins cvd_4g
mat A=r(table)
post tb1cvd4g ("region_is_urban") (A[1,1]*100) (.) (A[1,2]*100) (.) (A[1,3]*100) (.) (A[1,4]*100) (.)

local covs="edu_2g income_2g occu_2g smk_2g alc_2g fasting self_rated_poor diabetes ht fam_diabetes fam_cvd"
foreach cov of local covs {
logistic `cov' `t1'
margins cvd_4g
mat A=r(table)
post tb1cvd4g ("`cov'") (A[1,1]*100) (.) (A[1,2]*100) (.) (A[1,3]*100) (.) (A[1,4]*100) (.)
}

postclose tb1cvd4g

use "`PPP'\results\tb1cvd4g.dta"
replace CT = 1377 in 1
replace MI = 946 in 1
replace IS = 1217 in 1
replace ICH = 1238 in 1
save "`PPP'\results\tb1cvd4g.dta", replace
export excel using "`PPP'\results\tb1cvd4g.xlsx", firstrow(variables) replace
